#include <WinSock2.h>
#include <iostream>

#include "comm.h"

Comm::Comm(char* hostname) {
	socket_init();
	socket_connect(hostname);
	std::cout << "Socket connected\n";
	activ = true;
}
Comm::~Comm() {
	closesocket(*scet);
	WSACleanup();
}

void Comm::socket_init() {
	WORD sockVersion;
	WSADATA wsaData;
	sockVersion = MAKEWORD(2, 2);
	WSAStartup(sockVersion, &wsaData);
}
void Comm::socket_connect(char* hostname) {
	int nret;

	// Store information about the server
	LPHOSTENT hostEntry;
	hostEntry = gethostbyname(hostname);
	//hostEntry = gethostbyaddr(hostname, strlen(hostname), 0);		
												
	if (!hostEntry) {
		nret = WSAGetLastError();
		ReportError(nret, "gethostbyname()");	// Report the error as before
		WSACleanup();
		return;
	}

	// Create the socket
	scet = new SOCKET;

	// Go over TCP/IP, This is a stream-oriented socket, Use TCP rather than UDP
	*scet = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);

	if (*scet == INVALID_SOCKET) {
		nret = WSAGetLastError();
		ReportError(nret, "socket()");
		WSACleanup();
		return;
	}

	// Fill a SOCKADDR_IN struct with address information
	SOCKADDR_IN serverInfo;
	serverInfo.sin_family = AF_INET;
	serverInfo.sin_addr = *((LPIN_ADDR)*hostEntry->h_addr_list);
	serverInfo.sin_port = htons(1986);

	// Connect to the server
	nret = connect(*scet, (LPSOCKADDR)&serverInfo, sizeof(struct sockaddr));
	if (nret == SOCKET_ERROR) {
		nret = WSAGetLastError();
		ReportError(nret, "connect()");
		WSACleanup();
		return;
	}
}
void Comm::ReportError(int errorCode, const char *whichFunc) {
	char errorMsg[92];		// Declare a buffer to hold
							// the generated error message

	ZeroMemory(errorMsg, 92);	// Automatically NULL-terminate the string
	
	// The following line copies the phrase, whichFunc string, and integer errorCode into the buffer
	std::cout << errorMsg << "\nCall to " << (char *)whichFunc << " returned error " << errorCode << "!";
	//MessageBox(NULL, errorMsg, "socketIndication", MB_OK);
}

void Comm::s(char* msg) {
	send(*scet, msg, strlen(msg), 0);
}
char* Comm::r(char delim) {
	char* ret, tmp_str[BUFLEN], tmp;
	int number = 0, status;
	status = recv(*scet, &tmp, 1, 0);
	if(tmp < 32 || tmp > 122) activ = false;
	while(number < BUFLEN-1 && tmp != delim && status && active()) {
		tmp_str[number++] = tmp;
		status = recv(*scet, &tmp, 1, 0);
	}
	tmp_str[number] = '\0';
	
	ret = new char[strlen(tmp_str) + 1];
	strcpy(ret, tmp_str);
	return ret;
}